/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cil4sys.communication.launcher.websocket.common;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.papyrus.cil4sys.communication.launcher.websocket.process.ExecutableProcess;
import org.eclipse.papyrus.cil4sys.communication.launcher.websocket.process.ProcessHelper;
import org.eclipse.papyrus.cil4sys.communication.launcher.websocket.process.ProcessHelperProvider;

public class LauncherExecutableManager {
    private static final int DEFAULT_SLEEP_TIME = 1000;
    private static Map<Integer, ExecutableProcess> inProgressProcesses = new HashMap<Integer, ExecutableProcess>();
    private static boolean runInBackground = false;
    private Collection<String> paths;
    private String name;
    private String ip;
    private int port;

    public LauncherExecutableManager(Collection<String> paths, String name, String ip, int port) {
        this.paths = paths;
        this.name = name;
        this.ip = ip;
        this.port = port;
    }

    public static void setRunInBackground(boolean runInBackground) {
        LauncherExecutableManager.runInBackground = runInBackground;
    }

    public boolean launchExe() {
        ProcessHelper helper = ProcessHelperProvider.getProcessHelper(this.paths, this.ip);
        if (helper == null) {
            return false;
        }
        Process starterProcess = helper.launchExecutableProcess(this.port, runInBackground);
        if (starterProcess != null) {
            ExecutableProcess exeProcess = new ExecutableProcess(starterProcess, this.name, helper.getFilePath(), this.ip);
            inProgressProcesses.put(this.port, exeProcess);
            return true;
        }
        return false;
    }

    public static void closeExeWithSleep(int port) {
        LauncherExecutableManager.closeExe(port);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    public static void closeExe(int port) {
        LauncherExecutableManager.killProcess(port);
        inProgressProcesses.remove(port);
    }

    public static void closeExeWithSleep() {
        LauncherExecutableManager.closeExe();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    public static void closeExe() {
        for (Map.Entry<Integer, ExecutableProcess> entry : inProgressProcesses.entrySet()) {
            LauncherExecutableManager.killProcess(entry.getKey());
        }
        inProgressProcesses.clear();
    }

    private static void killProcess(Integer port) {
        ExecutableProcess exeProcess = inProgressProcesses.get(port);
        String ip = exeProcess.getIp();
        ProcessHelper helper = null;
        if (exeProcess != null) {
            String path;
            Process process = exeProcess.getProcess();
            if (process != null) {
                process.destroy();
            }
            if ((path = exeProcess.getPath()) != null && !path.isEmpty()) {
                helper = ProcessHelperProvider.getProcessHelper(path, ip);
            }
        }
        if (helper == null) {
            return;
        }
        long id = -1L;
        try {
            id = helper.getProcessID(port);
        }
        catch (IOException | InterruptedException e1) {
            e1.printStackTrace();
        }
        if (id != -1L) {
            helper.killProcess(id);
        }
    }
}

