/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cil4sys.communication.launcher.websocket.process;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.papyrus.cil4sys.communication.launcher.websocket.process.ProcessHelper;

public abstract class AbstractProcessHelper
implements ProcessHelper {
    private final String filePath;

    public AbstractProcessHelper(String path) {
        this.filePath = path;
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public Process launchProcess(String ... commands) {
        ProcessBuilder builder = new ProcessBuilder(commands);
        try {
            return builder.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Process launchProcess(String commandString) {
        ArrayList<String> commands = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(commandString);
        while (tokenizer.hasMoreElements()) {
            String command = (String)tokenizer.nextElement();
            commands.add(command);
        }
        String[] array = new String[commands.size()];
        array = commands.toArray(array);
        return this.launchProcess(array);
    }

    protected abstract String[] getRetrieveProcessIdByPortCommand(int var1);

    protected abstract String[] getKillProcessByIdCommand(long var1);

    protected abstract String[] getLaunchExecutableProcessCommand(String var1, int var2, boolean var3);
}

