/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cil4sys.communication.launcher.websocket.process;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.papyrus.cil4sys.communication.launcher.websocket.common.OSValidator;
import org.eclipse.papyrus.cil4sys.communication.launcher.websocket.process.AbstractProcessHelper;
import org.eclipse.papyrus.cil4sys.communication.launcher.websocket.process.ProcessHelper;
import org.eclipse.papyrus.cil4sys.communication.launcher.websocket.process.RemoteUnixProcessHelper;
import org.eclipse.papyrus.cil4sys.communication.launcher.websocket.process.UnixProcessHelper;
import org.eclipse.papyrus.cil4sys.communication.launcher.websocket.process.WSLProcessHelper;
import org.eclipse.papyrus.cil4sys.communication.launcher.websocket.process.WindowsProcessHelper;

public final class ProcessHelperProvider {
    private ProcessHelperProvider() {
    }

    public static ProcessHelper getProcessHelper(String path, String ip) {
        return ProcessHelperProvider.getProcessHelper(Collections.singleton(path), ip);
    }

    public static ProcessHelper getProcessHelper(Collection<String> paths, String ip) {
        AbstractProcessHelper helper = null;
        if (ip.equals("localhost") || ip.equals("127.0.0.1")) {
            String fullPath = ProcessHelperProvider.getMatchingLocalPathAndFile(paths);
            if (fullPath.isEmpty()) {
                return null;
            }
            String extension = FilenameUtils.getExtension((String)fullPath);
            if (OSValidator.isWindows()) {
                if (extension == null || extension.isEmpty()) {
                    helper = new WSLProcessHelper(fullPath);
                } else if ("exe".equals(extension)) {
                    helper = new WindowsProcessHelper(fullPath);
                }
            } else if (OSValidator.isUnix()) {
                helper = new UnixProcessHelper(fullPath);
            }
        } else {
            String fullPath = ProcessHelperProvider.getMatchingRemotePathAndFile(ip, paths);
            if (OSValidator.isWindows()) {
                helper = new RemoteUnixProcessHelper(ip, fullPath);
            }
        }
        return helper;
    }

    private static String getMatchingLocalPathAndFile(Collection<String> paths) {
        for (String path : paths) {
            String fullPath = path;
            File tmp = new File(fullPath);
            if (!tmp.exists()) continue;
            return fullPath;
        }
        return "";
    }

    private static String getMatchingRemotePathAndFile(String ip, Collection<String> paths) {
        Iterator<String> iterator = paths.iterator();
        while (iterator.hasNext()) {
            String path;
            String fullPath = path = iterator.next();
            Object output = "";
            try {
                String[] cmd = new String[]{"cmd", "/c", "ssh", ip, "ls -a " + fullPath};
                ProcessBuilder builder = new ProcessBuilder(cmd);
                Process process = builder.start();
                InputStream stream = process.getInputStream();
                int bytesRead = -1;
                byte[] bytes = new byte[1024];
                while ((bytesRead = stream.read(bytes)) > -1) {
                    output = (String)output + new String(bytes, 0, bytesRead);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (((String)output).isEmpty()) continue;
            return path;
        }
        return "";
    }
}

