/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cil4sys.communication.launcher.websocket.process;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.papyrus.cil4sys.communication.launcher.websocket.process.AbstractRemoteProcessHelper;

public class RemoteUnixProcessHelper
extends AbstractRemoteProcessHelper {
    private static final String TAG = "(LISTEN)";

    public RemoteUnixProcessHelper(String ip, String path) {
        super(ip, path);
    }

    @Override
    public long getProcessID(int port) {
        int processID = -1;
        try {
            ProcessBuilder builder = new ProcessBuilder(this.getRetrieveProcessIdByPortCommand(port));
            Process process = builder.start();
            InputStream inputStream = process.getInputStream();
            processID = this.findProcessID(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return processID;
    }

    private int findProcessID(InputStream stream) throws IOException {
        int processID = -1;
        int bytesRead = -1;
        byte[] bytes = new byte[1024];
        Object output = "";
        while ((bytesRead = stream.read(bytes)) > -1) {
            output = (String)output + new String(bytes, 0, bytesRead);
        }
        System.out.println((String)output);
        String[] lines = ((String)output).split("\\r?\\n");
        List<String> linesList = Arrays.asList(lines);
        Iterator<String> iterator = linesList.iterator();
        if (!linesList.isEmpty()) {
            iterator.next();
            block1: while (iterator.hasNext() && processID == -1) {
                String line = iterator.next();
                int tmpProcessID = -1;
                StringTokenizer tokenizer = new StringTokenizer(line);
                int position = 0;
                while (tokenizer.hasMoreElements()) {
                    if (position == 1) {
                        String processIDString = (String)tokenizer.nextElement();
                        tmpProcessID = Integer.valueOf(processIDString);
                    } else if (position == 9) {
                        String processNameComment = (String)tokenizer.nextElement();
                        if (processNameComment.contains(TAG)) {
                            processID = tmpProcessID;
                            continue block1;
                        }
                    } else {
                        tokenizer.nextElement();
                    }
                    ++position;
                }
            }
        }
        return processID;
    }

    @Override
    public Process launchExecutableProcess(int port) {
        return this.launchExecutableProcess(port, false);
    }

    @Override
    public void killProcess(long id) {
        ProcessBuilder builder = new ProcessBuilder(this.getKillProcessByIdCommand(id));
        try {
            builder.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public long getProcessID(Process p) {
        long result = -1L;
        try {
            if (p.getClass().getName().equals("java.lang.UNIXProcess")) {
                Field f = p.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                result = f.getLong(p);
                f.setAccessible(false);
            }
        }
        catch (Exception ex) {
            result = -1L;
        }
        return result;
    }

    @Override
    public void killProcess(String name) {
    }

    @Override
    public Process launchExecutableProcess(int port, boolean background) {
        String prefix = FilenameUtils.getPrefix((String)this.getFilePath());
        prefix = prefix.toLowerCase().replaceFirst(":/", "");
        String path = this.getFilePath();
        return this.launchProcess(this.getLaunchExecutableProcessCommand(path, port, background));
    }

    @Override
    protected String[] getLaunchExecutableProcessCommand(String path, int port, boolean inBackground) {
        String[] cmd = new String[]{"cmd.exe", "/c", "start", "cmd", "/c", "ssh " + this.getIp(), path, String.valueOf(port)};
        return cmd;
    }

    @Override
    protected String[] getRetrieveProcessIdByPortCommand(int port) {
        String[] cmd = new String[]{"cmd", "/c", "ssh " + this.getIp(), "lsof", "-i", ":" + String.valueOf(port)};
        return cmd;
    }

    @Override
    protected String[] getKillProcessByIdCommand(long id) {
        String[] cmd = new String[]{"cmd", "/c", "ssh " + this.getIp(), "kill", "-9", String.valueOf(id)};
        return cmd;
    }
}

