/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cil4sys.communication.launcher.websocket.process;

import org.apache.commons.io.FilenameUtils;
import org.eclipse.papyrus.cil4sys.communication.launcher.websocket.process.AbstractLocalUnixDerivativeProcessHelper;

public class WSLProcessHelper
extends AbstractLocalUnixDerivativeProcessHelper {
    public WSLProcessHelper(String path) {
        super(path);
    }

    @Override
    public Process launchExecutableProcess(int port, boolean background) {
        String prefix = FilenameUtils.getPrefix((String)this.getFilePath());
        prefix = prefix.toLowerCase().replaceFirst(":\\\\", "").replaceFirst(":/", "");
        String path = this.getFilePath().replace("\\", "/").replaceFirst("[a-zA-Z]:", "/mnt/" + prefix);
        return this.launchProcess(this.getLaunchExecutableProcessCommand(path, port, background));
    }

    @Override
    protected String[] getLaunchExecutableProcessCommand(String path, int port, boolean inBackground) {
        String[] cmd = new String[]{"cmd.exe", "/c", "start", "cmd", "/c", "wsl", "\"" + path + "\"", String.valueOf(port)};
        return cmd;
    }

    @Override
    protected String[] getRetrieveProcessIdByPortCommand(int port) {
        String[] cmd = new String[]{"wsl", "lsof", "-i", ":" + String.valueOf(port)};
        return cmd;
    }

    @Override
    protected String[] getKillProcessByIdCommand(long id) {
        String[] cmd = new String[]{"wsl", "kill", "-9", String.valueOf(id)};
        return cmd;
    }
}

