/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cil4sys.communication.launcher.websocket.process;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.papyrus.cil4sys.communication.launcher.websocket.process.AbstractLocalProcessHelper;

public class WindowsProcessHelper
extends AbstractLocalProcessHelper {
    private static final String TAG = "LISTENING";

    public WindowsProcessHelper(String path) {
        super(path);
    }

    @Override
    public void killProcess(long id) {
        ProcessBuilder builder = new ProcessBuilder(this.getKillProcessByIdCommand(id));
        try {
            builder.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void killProcess(String name) {
        ProcessBuilder builder = new ProcessBuilder("taskkill", "/IM", "\"" + name + "\"", "/F");
        try {
            builder.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public long getProcessID(int port) {
        int processID = -1;
        try {
            ProcessBuilder builder = new ProcessBuilder(this.getRetrieveProcessIdByPortCommand(port));
            Process process = builder.start();
            InputStream inputStream = process.getInputStream();
            int bytesRead = -1;
            byte[] bytes = new byte[1024];
            Object output = "";
            while ((bytesRead = inputStream.read(bytes)) > -1) {
                output = (String)output + new String(bytes, 0, bytesRead);
            }
            String[] lines = ((String)output).split("\\r?\\n");
            List<String> linesList = Arrays.asList(lines);
            if (!linesList.isEmpty()) {
                String firstLine = linesList.get(0);
                StringTokenizer tokenizer = new StringTokenizer(firstLine);
                while (tokenizer.hasMoreElements()) {
                    String object = (String)tokenizer.nextElement();
                    if (!object.equals(TAG) || !tokenizer.hasMoreElements()) continue;
                    String processIDString = (String)tokenizer.nextElement();
                    processID = Integer.valueOf(processIDString);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return processID;
    }

    @Override
    public long getProcessID(Process p) {
        long result = -1L;
        try {
            if (p.getClass().getName().equals("java.lang.Win32Process") || p.getClass().getName().equals("java.lang.ProcessImpl")) {
                Field f = p.getClass().getDeclaredField("handle");
                f.setAccessible(true);
                long handl = f.getLong(p);
                Kernel32 kernel = Kernel32.INSTANCE;
                WinNT.HANDLE hand = new WinNT.HANDLE();
                hand.setPointer(Pointer.createConstant((long)handl));
                result = kernel.GetProcessId(hand);
                f.setAccessible(false);
            }
        }
        catch (Exception ex) {
            result = -1L;
        }
        return result;
    }

    @Override
    public Process launchExecutableProcess(int port) {
        return this.launchExecutableProcess(port, false);
    }

    @Override
    public Process launchExecutableProcess(int port, boolean background) {
        String path = this.getFilePath();
        return this.launchProcess(this.getLaunchExecutableProcessCommand(path, port, background));
    }

    @Override
    protected String[] getLaunchExecutableProcessCommand(String path, int port, boolean inBackground) {
        String baseUrl = FilenameUtils.getFullPath((String)path);
        String[] fullCmd = new String[]{"cmd.exe", "/c", "\"cd", "\"" + baseUrl + "\"", "&&start", "\"\"", "\"" + path + "\"", String.valueOf(port) + "\""};
        if (inBackground) {
            String[] backgroundCommands = new String[]{path, String.valueOf(port)};
            fullCmd = backgroundCommands;
        }
        return fullCmd;
    }

    @Override
    protected String[] getRetrieveProcessIdByPortCommand(int port) {
        String[] cmd = new String[]{"cmd.exe", "/C", "netstat -ano | findstr", ":" + String.valueOf(port)};
        return cmd;
    }

    @Override
    protected String[] getKillProcessByIdCommand(long id) {
        String[] cmd = new String[]{"taskkill", "/T", "/PID", String.valueOf(id), "/F"};
        return cmd;
    }
}

