/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cil4sys.communication.launcher.websocket.server;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.cil4sys.communication.launcher.websocket.common.LauncherExecutableManager;
import org.eclipse.papyrus.cil4sys.communication.model.Sim4SysConstants;
import org.eclipse.papyrus.cil4sys.communication.model.data.Sim4SysExecutableInstance;
import org.eclipse.papyrus.cil4sys.communication.model.data.WebSocketStatus;
import org.eclipse.papyrus.cil4sys.communication.model.elements.Sim4SysData;
import org.eclipse.papyrus.cil4sys.communication.model.elements.Sim4SysModelObject;
import org.eclipse.papyrus.cil4sys.communication.model.elements.Sim4SysObject;
import org.eclipse.papyrus.cil4sys.communication.model.elements.Sim4SysObjects;
import org.eclipse.papyrus.cil4sys.communication.websocket.server.AbstractExchangedMessageInterpreter;

public class LauncherExchangedMessageInterpreter
extends AbstractExchangedMessageInterpreter {
    public LauncherExchangedMessageInterpreter(Sim4SysModelObject sim4sysContent) {
        super(sim4sysContent);
    }

    public void interpret() {
        if (this.input instanceof Sim4SysObjects) {
            Sim4SysObjects objects = (Sim4SysObjects)this.input;
            if (objects.getName().equals("receivedValues")) {
                this.receivedValues(objects.getObjects());
            }
        } else if (this.input instanceof Sim4SysData) {
            Sim4SysData data = (Sim4SysData)this.input;
            this.receivedValues(data);
        }
    }

    private void receivedValues(Sim4SysData data) {
        if ("cmd".equals(data.getName()) && "stop".equals(data.getValue())) {
            LauncherExecutableManager.closeExeWithSleep();
        }
    }

    private void receivedValues(List<Sim4SysObject> objects) {
        for (Sim4SysObject obj : objects) {
            if (!obj.getType().equals(Sim4SysConstants.EXECUTABLE_IN_SCENARIO)) continue;
            this.receiveExecutable(obj);
        }
    }

    private void receiveExecutable(Sim4SysObject obj) {
        Sim4SysExecutableInstance instance = new Sim4SysExecutableInstance();
        for (Sim4SysData data : obj.getData()) {
            switch (data.getName()) {
                case "exe_name": {
                    instance.setExeName(data.getValue());
                    break;
                }
                case "ws_name": {
                    instance.setWebSocketName(data.getValue());
                    break;
                }
                case "port": {
                    instance.setPort(Integer.valueOf(data.getValue()).intValue());
                    break;
                }
                case "ipv4": {
                    instance.setIP(data.getValue());
                    break;
                }
                case "path": {
                    instance.addPath(data.getValue());
                    break;
                }
            }
        }
        this.launchExecutableInstance(instance);
    }

    private void launchExecutableInstance(Sim4SysExecutableInstance instance) {
        LauncherExecutableManager exeManager = new LauncherExecutableManager(instance.getPaths(), instance.getExeName(), instance.getIP(), instance.getPort());
        boolean running = exeManager.launchExe();
        if (running) {
            this.reportStatus(instance, WebSocketStatus.RUNNING);
        }
    }

    private void reportStatus(Sim4SysExecutableInstance instance, WebSocketStatus status) {
        Sim4SysObjects objects = new Sim4SysObjects();
        objects.setName("sentValues");
        ArrayList<Sim4SysData> datas = new ArrayList<Sim4SysData>();
        Sim4SysData data = new Sim4SysData("exe_name", instance.getExeName());
        datas.add(data);
        data = new Sim4SysData("ws_name", instance.getWebSocketName());
        datas.add(data);
        data = new Sim4SysData("ipv4", String.valueOf(instance.getIP()));
        datas.add(data);
        data = new Sim4SysData("port", String.valueOf(instance.getPort()));
        datas.add(data);
        data = new Sim4SysData("status", status.getSerializableName());
        datas.add(data);
        Sim4SysObject object = new Sim4SysObject("websocket_created", "test", datas);
        objects.addObject(object);
        this.output = objects;
    }

    public Sim4SysModelObject getAnswer() {
        return this.output;
    }
}

