/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cil4sys.communication.launcher.websocket.server;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.EncodeException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.eclipse.papyrus.cil4sys.communication.launcher.websocket.common.LauncherExecutableManager;
import org.eclipse.papyrus.cil4sys.communication.launcher.websocket.server.LauncherConfigurator;
import org.eclipse.papyrus.cil4sys.communication.launcher.websocket.server.LauncherExchangedMessageInterpreter;
import org.eclipse.papyrus.cil4sys.communication.model.elements.Sim4SysInit;
import org.eclipse.papyrus.cil4sys.communication.model.elements.Sim4SysModelObject;
import org.eclipse.papyrus.cil4sys.communication.websocket.server.ExchangedMessage;
import org.eclipse.papyrus.cil4sys.communication.websocket.server.ExchangedMessageDecoder;
import org.eclipse.papyrus.cil4sys.communication.websocket.server.ExchangedMessageEncoder;

@ServerEndpoint(value="/", decoders={ExchangedMessageDecoder.class}, encoders={ExchangedMessageEncoder.class}, configurator=LauncherConfigurator.class)
public class LauncherServerEndpoint {
    private static Logger LOGGER;
    private Session session;

    @OnOpen
    public void onOpen(Session session) throws IOException {
        LOGGER = Logger.getLogger(LauncherServerEndpoint.class.getName());
        LOGGER.log(Level.INFO, "Open websocket session.");
        this.session = session;
        ExchangedMessage message = new ExchangedMessage();
        Sim4SysInit init = new Sim4SysInit();
        init.setVersion("1.0");
        message.setSim4sysContent((Sim4SysModelObject)init);
        this.broadcast(message);
    }

    @OnMessage
    public void onMessage(Session session, ExchangedMessage message) throws IOException {
        LauncherExchangedMessageInterpreter interpreter = new LauncherExchangedMessageInterpreter(message.getSim4sysContent());
        interpreter.interpret();
        Sim4SysModelObject answerObject = interpreter.getAnswer();
        if (answerObject != null) {
            ExchangedMessage answerMessage = new ExchangedMessage();
            answerMessage.setSim4sysContent(answerObject);
            this.broadcast(answerMessage);
        }
    }

    @OnClose
    public void onClose(Session session) throws IOException {
        LOGGER.log(Level.INFO, "Close websocket session.");
        LauncherExecutableManager.closeExe();
    }

    @OnError
    public void onError(Session session, Throwable throwable) {
        LOGGER.log(Level.SEVERE, "Error");
        throwable.fillInStackTrace().printStackTrace();
    }

    private void broadcast(ExchangedMessage message) {
        try {
            this.session.getBasicRemote().sendObject((Object)message);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EncodeException e) {
            e.printStackTrace();
        }
    }
}

