/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cil4sys.communication.websocket.server;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.DeploymentException;
import org.eclipse.papyrus.cil4sys.communication.websocket.server.WebSocketServerManager;
import org.eclipse.swt.widgets.Display;
import org.glassfish.tyrus.server.Server;

public abstract class WebSocketServer {
    private int port;
    private String serverAdress;
    private Logger logger;
    private Server server;
    private Class<?> endpoint;
    private boolean running = false;
    private List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getServerAdress() {
        return this.serverAdress;
    }

    public void setServerAdress(String serverAdress) {
        this.serverAdress = serverAdress;
    }

    public void startServer() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                block10: {
                    if (!WebSocketServer.this.isRunning()) {
                        WebSocketServer.this.logger = Logger.getLogger(WebSocketServer.this.endpoint.getName());
                        WebSocketServer.this.server = new Server(WebSocketServer.this.serverAdress, WebSocketServer.this.port, "/", null, new Class[]{WebSocketServer.this.endpoint});
                        try {
                            try {
                                WebSocketServer.this.logger.log(Level.INFO, "Start server on port " + WebSocketServer.this.port);
                                WebSocketServer.this.server.start();
                                WebSocketServer.this.setRunning(true);
                                WebSocketServer.this.register();
                                while (WebSocketServer.this.isRunning()) {
                                    Thread.sleep(20L);
                                }
                                break block10;
                            }
                            catch (DeploymentException e) {
                                e.printStackTrace();
                                throw new RuntimeException(e);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                                WebSocketServer.this.logger.log(Level.INFO, "Stop server on port " + WebSocketServer.this.port);
                                WebSocketServer.this.server.stop();
                                break block10;
                            }
                            catch (RuntimeException e) {
                                e.printStackTrace();
                                WebSocketServer.this.logger.log(Level.INFO, "Stop server on port " + WebSocketServer.this.port);
                                WebSocketServer.this.server.stop();
                                break block10;
                            }
                        }
                        finally {
                            WebSocketServer.this.logger.log(Level.INFO, "Stop server on port " + WebSocketServer.this.port);
                            WebSocketServer.this.server.stop();
                        }
                    }
                    WebSocketServer.this.logger.log(Level.WARNING, "Server already running on port " + WebSocketServer.this.port + "!");
                }
            }
        });
        t.start();
    }

    private void register() {
        WebSocketServerManager.getInstance().register(this.port, this);
    }

    public void stopServer() {
        this.logger = Logger.getLogger(this.endpoint.getName());
        if (this.isRunning()) {
            this.logger.log(Level.INFO, "Stop server on port " + this.port);
            if (this.server != null) {
                this.server.stop();
            }
            this.setRunning(false);
        } else {
            this.logger.log(Level.WARNING, "Server already stopped!");
        }
    }

    protected Class<?> getEndpoint() {
        return this.endpoint;
    }

    protected void setEndpoint(Class<?> endpoint) {
        this.endpoint = endpoint;
    }

    public boolean isRunning() {
        return this.running;
    }

    private void setRunning(boolean runningState) {
        final boolean oldValue = this.running;
        this.running = runningState;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                WebSocketServer.this.fireListeners("runningState", oldValue, WebSocketServer.this.running);
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void fireListeners(String propertyName, boolean oldValue, boolean newValue) {
        for (PropertyChangeListener listener : this.listeners) {
            PropertyChangeEvent event = new PropertyChangeEvent(WebSocketServer.class, propertyName, oldValue, newValue);
            listener.propertyChange(event);
        }
    }
}

