/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cil4sys.communication.websocket.server;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.papyrus.cil4sys.communication.websocket.server.WebSocketServer;

public final class WebSocketServerManager {
    private static WebSocketServerManager instance;
    private static Map<Integer, WebSocketServer> serverRegistry;

    static {
        serverRegistry = new HashMap<Integer, WebSocketServer>();
    }

    private WebSocketServerManager() {
    }

    public static WebSocketServerManager getInstance() {
        if (instance == null) {
            instance = new WebSocketServerManager();
        }
        return instance;
    }

    public static WebSocketServer get(int port) {
        return serverRegistry.get(port);
    }

    public static <T extends WebSocketServer> T get(Class<T> websocketServerClass) {
        for (Map.Entry<Integer, WebSocketServer> entry : serverRegistry.entrySet()) {
            if (!websocketServerClass.isInstance(entry.getValue())) continue;
            return (T)entry.getValue();
        }
        if (websocketServerClass != null) {
            try {
                WebSocketServer t = (WebSocketServer)websocketServerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                serverRegistry.put(t.getPort(), t);
                return (T)t;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void register(int port, WebSocketServer webSocketServer) {
        serverRegistry.put(port, webSocketServer);
    }
}

