/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cil4sys.communication.partner.websocket.server;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.EncodeException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.eclipse.papyrus.cil4sys.communication.model.elements.Sim4SysModelObject;
import org.eclipse.papyrus.cil4sys.communication.model.elements.Sim4SysObject;
import org.eclipse.papyrus.cil4sys.communication.model.elements.Sim4SysObjects;
import org.eclipse.papyrus.cil4sys.communication.partner.websocket.server.PartnerConfigurator;
import org.eclipse.papyrus.cil4sys.communication.partner.websocket.server.PartnerExchangedMessageInterpreter;
import org.eclipse.papyrus.cil4sys.communication.websocket.server.ExchangedMessage;
import org.eclipse.papyrus.cil4sys.communication.websocket.server.ExchangedMessageDecoder;
import org.eclipse.papyrus.cil4sys.communication.websocket.server.ExchangedMessageEncoder;

@ServerEndpoint(value="/", decoders={ExchangedMessageDecoder.class}, encoders={ExchangedMessageEncoder.class}, configurator=PartnerConfigurator.class)
public class PartnerServerEndpoint {
    private static final Logger LOGGER = Logger.getLogger(PartnerServerEndpoint.class.getName());
    static Queue<Session> sessions = new ConcurrentLinkedQueue<Session>();

    @OnOpen
    public void onOpen(Session session) throws IOException {
        LOGGER.log(Level.INFO, "Open websocket session.");
        sessions.add(session);
        ExchangedMessage message = new ExchangedMessage();
        Sim4SysObjects init = new Sim4SysObjects();
        init.setName("commands");
        Sim4SysObject object = new Sim4SysObject("acceptation", "", Collections.emptyList());
        init.addObject(object);
        message.setSim4sysContent((Sim4SysModelObject)init);
        this.broadcast(message);
    }

    @OnMessage
    public void onMessage(Session session, ExchangedMessage message) throws IOException {
        PartnerExchangedMessageInterpreter interpreter = new PartnerExchangedMessageInterpreter(message.getSim4sysContent());
        interpreter.interpret();
        Sim4SysModelObject answerObject = interpreter.getAnswer();
        if (answerObject != null) {
            ExchangedMessage answerMessage = new ExchangedMessage();
            answerMessage.setSim4sysContent(answerObject);
            this.broadcast(answerMessage);
        }
    }

    @OnClose
    public void onClose(Session session) throws IOException {
        LOGGER.log(Level.INFO, "Close websocket session.");
        sessions.remove(session);
    }

    @OnError
    public void onError(Session session, Throwable throwable) {
        LOGGER.log(Level.SEVERE, "Error");
        sessions.remove(session);
        throwable.fillInStackTrace().printStackTrace();
    }

    private void broadcast(ExchangedMessage message) {
        try {
            for (Session session : sessions) {
                session.getBasicRemote().sendObject((Object)message);
                LOGGER.log(Level.INFO, "Send: {0} ", String.valueOf(message) + " to " + session.getId());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EncodeException e) {
            e.printStackTrace();
        }
    }

    public static void broadcast(File file) {
        ByteBuffer buffer = null;
        if (file != null) {
            try {
                byte[] bytes = Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0]));
                buffer = ByteBuffer.wrap(bytes);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (buffer != null) {
            try {
                for (Session session : sessions) {
                    session.getBasicRemote().sendBinary(buffer);
                    LOGGER.log(Level.INFO, "Send: {0} ", String.valueOf(file) + " to " + session.getId());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

