/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cil4sys.applications.launcher.rcp.overview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.papyrus.cil4sys.communication.launcher.websocket.common.LauncherExecutableManager;
import org.eclipse.papyrus.cil4sys.communication.launcher.websocket.server.LauncherWebSocketServer;
import org.eclipse.papyrus.cil4sys.communication.websocket.server.WebSocketServerManager;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class LauncherOverview
implements PropertyChangeListener {
    private CLabel label;
    private Group serverGroup;
    private Composite container;

    @Inject
    public LauncherOverview() {
    }

    @PostConstruct
    public void postConstruct(Composite parent) {
        this.container = parent;
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LauncherWebSocketServer server = (LauncherWebSocketServer)WebSocketServerManager.get(LauncherWebSocketServer.class);
                server.stopServer();
                server.removePropertyChangeListener((PropertyChangeListener)LauncherOverview.this);
            }
        });
        GridLayout gridLayout = GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(true).create();
        parent.setLayout((Layout)gridLayout);
        this.serverGroup = new Group(parent, 0);
        this.serverGroup.setText("Server");
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo((Composite)this.serverGroup);
        GridDataFactory.fillDefaults().span(2, 1).align(0x1000000, 0x1000000).grab(true, true).align(4, 1).applyTo((Control)this.serverGroup);
        final Button startStopButton = new Button((Composite)this.serverGroup, 2);
        startStopButton.setText("Start/Stop Launcher");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)startStopButton);
        startStopButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = startStopButton.getSelection();
                LauncherWebSocketServer server = (LauncherWebSocketServer)WebSocketServerManager.get(LauncherWebSocketServer.class);
                if (server.isRunning() && !selection) {
                    server.stopServer();
                } else if (!server.isRunning() && selection) {
                    server.startServer();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.label = new CLabel((Composite)this.serverGroup, 0x1000000);
        this.label.setText("StandBy");
        GridDataFactory.fillDefaults().grab(true, false).align(4, 4).applyTo((Control)this.label);
        final Button backgroundButton = new Button((Composite)this.serverGroup, 2);
        backgroundButton.setText("Run in background");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)backgroundButton);
        backgroundButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = backgroundButton.getSelection();
                LauncherExecutableManager.setRunInBackground((boolean)selection);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        LauncherWebSocketServer server = (LauncherWebSocketServer)WebSocketServerManager.get(LauncherWebSocketServer.class);
        server.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void updateServerStateIndicator() {
        LauncherWebSocketServer server = (LauncherWebSocketServer)WebSocketServerManager.get(LauncherWebSocketServer.class);
        if (server.isRunning()) {
            this.label.setText("Running");
        } else {
            this.label.setText("StandBy");
        }
        this.container.layout();
        this.container.redraw();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("runningState".equals(propertyName)) {
            this.updateServerStateIndicator();
        }
    }
}

